/*
 * Decompiled with CFR 0.152.
 */
package org.python.posix;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import org.python.constantine.platform.Errno;
import org.python.posix.FileStat;
import org.python.posix.JavaFileStat;
import org.python.posix.JavaPOSIX;
import org.python.posix.JavaPasswd;
import org.python.posix.JavaSecuredFile;
import org.python.posix.POSIXHandler;
import org.python.posix.Passwd;
import org.python.posix.util.Chmod;
import org.python.posix.util.ExecIt;
import org.python.posix.util.FieldAccess;

public class JavaLibCHelper {
    public static final int STDIN = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    private final POSIXHandler handler;
    private final Field fdField;
    private final Field handleField;
    ThreadLocal<Integer> pwIndex = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public JavaLibCHelper(POSIXHandler pOSIXHandler) {
        this.handler = pOSIXHandler;
        this.handleField = FieldAccess.getProtectedField(FileDescriptor.class, "handle");
        this.fdField = FieldAccess.getProtectedField(FileDescriptor.class, "fd");
    }

    public int chmod(String string, int n) {
        return Chmod.chmod(new JavaSecuredFile(string), Integer.toOctalString(n));
    }

    public int chown(String string, int n, int n2) {
        ExecIt execIt = new ExecIt(this.handler);
        int n3 = -1;
        int n4 = -1;
        try {
            if (n != -1) {
                n3 = execIt.runAndWait("chown", "" + n, string);
            }
            if (n2 != -1) {
                n4 = execIt.runAndWait("chgrp ", "" + n, string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3 != -1 && n4 != -1 ? 0 : 1;
    }

    public int getfd(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null || this.fdField == null) {
            return -1;
        }
        try {
            return this.fdField.getInt(fileDescriptor);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    public long gethandle(FileDescriptor fileDescriptor) {
        if (fileDescriptor == null || this.handleField == null) {
            return -1L;
        }
        try {
            return this.handleField.getLong(fileDescriptor);
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1L;
    }

    public String getlogin() {
        return System.getProperty("user.name");
    }

    public int getpid() {
        return this.handler.getPID();
    }

    public Passwd getpwent() {
        JavaPasswd javaPasswd = this.pwIndex.get() == 0 ? new JavaPasswd(this.handler) : null;
        this.pwIndex.set(this.pwIndex.get() + 1);
        return javaPasswd;
    }

    public int setpwent() {
        return 0;
    }

    public int endpwent() {
        this.pwIndex.set(0);
        return 0;
    }

    public Passwd getpwuid(int n) {
        return n == JavaPOSIX.LoginInfo.UID ? new JavaPasswd(this.handler) : null;
    }

    public int isatty(int n) {
        return n == 1 || n == 0 || n == 2 ? 1 : 0;
    }

    public int link(String string, String string2) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", string, string2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int lstat(String string, FileStat fileStat) {
        JavaSecuredFile javaSecuredFile = new JavaSecuredFile(string);
        if (!((File)javaSecuredFile).exists()) {
            this.handler.error(Errno.ENOENT, string);
        }
        JavaFileStat javaFileStat = (JavaFileStat)fileStat;
        javaFileStat.setup(string);
        return 0;
    }

    public int mkdir(String string, int n) {
        JavaSecuredFile javaSecuredFile = new JavaSecuredFile(string);
        if (!((File)javaSecuredFile).mkdir()) {
            return -1;
        }
        this.chmod(string, n);
        return 0;
    }

    public int stat(String string, FileStat fileStat) {
        JavaFileStat javaFileStat = (JavaFileStat)fileStat;
        try {
            JavaSecuredFile javaSecuredFile = new JavaSecuredFile(string);
            if (!((File)javaSecuredFile).exists()) {
                this.handler.error(Errno.ENOENT, string);
            }
            javaFileStat.setup(((File)javaSecuredFile).getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 0;
    }

    public int symlink(String string, String string2) {
        try {
            return new ExecIt(this.handler).runAndWait("ln", "-s", string, string2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int readlink(String string, ByteBuffer byteBuffer, int n) throws IOException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ExecIt(this.handler).runAndWait(byteArrayOutputStream, "readlink", string);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length > n || byArray.length == 0) {
                return -1;
            }
            byteBuffer.put(byArray, 0, byArray.length - 1);
            return byteBuffer.position();
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }
}

